CREATE TABLE CD_Controladores_Novedades
(Id_Controlador			SMALLINT NOT NULL,			/*Controlador el cual debe sincronizarse*/
Id_Novedad				INT NOT NULL,				/*Item de Novedad de la sincronizacion*/
Fecha_Creacion			DATETIME NOT NULL,			/*Fecha en la cual se cre la novedad*/
Estado_Sincr			CHAR(1) NOT NULL,			/*P: Novedad Pendiente de Descargar. C: Novedad Descargada*/
Fecha_Sincr_Procesada	DATETIME,					/*Fecha en la que se realiz la descarga de la novedad*/
Resultado_Sinc_Procesada CHAR(1),					/*NULL: Todavia no se descargo. C: Procesada. E: Error*/
Id_Cliente				INT	NOT NULL,
Razon_Social			VARCHAR(100),
Credencial_Nro			VARCHAR(30),
Flag_Tiene_Huella		TINYINT,					/*0: El cliente no tiene huellas registradas. >0: Cantidad de Huellas registradas*/
Id_Usuario				SMALLINT					/*Id_Usuario que realiz la novedad*/

CONSTRAINT PK_CDLBN_PorId PRIMARY KEY CLUSTERED (Id_Controlador, Id_Novedad)
)
GO

ALTER TABLE CD_Controladores_Novedades ADD CONSTRAINT FK_CDLBN_Clientes FOREIGN KEY (Id_Cliente)
REFERENCES Clientes (Id_Cliente)
GO

ALTER TABLE CD_Controladores_Novedades ADD CONSTRAINT FK_CDLBN_CD_Controladores FOREIGN KEY (Id_Controlador)
REFERENCES CD_Controladores (Id_Controlador)
GO